/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.ws.listener.axis.rm.WSRequestForward;
import filenet.ws.listener.utils.Constants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.net.InetAddress;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;

class Request {
    Object sync = null;
    File m_inFile = null;
    MessageContext m_msgContext = null;
    Message m_reqMessage = null;
    InputStream m_inputStream = null;
    OutputStream m_outputStream = null;
    int m_targetPort = Constants.LISTENER_PROPERTY_WSRM_CLIENT_LISTENER_PORT_DEFAULT;
    String m_targetHost = WSRequestForward.DEFAULT_TARGET_HOST;
    protected static final String m_className = "WSRequestForward.Request";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request(MessageContext msgContext, int port, String host) {
        String m_method = "Request constructor";
        StringBuffer buf = new StringBuffer();
        WSRequestForward.logger.entering(m_className, m_method);
        this.m_targetPort = port;
        if (host != null) {
            this.m_targetHost = host;
        }
        buf.append("Target=").append(this.m_targetHost).append(":").append(this.m_targetPort);
        if (msgContext != null) {
            this.sync = msgContext;
            this.m_msgContext = msgContext;
            this.m_reqMessage = this.m_msgContext.getRequestMessage();
            try {
                Iterator it;
                String soapPart = this.m_reqMessage.getSOAPPartAsString();
                StringBuffer inMessageBuf = new StringBuffer();
                HttpServletRequest req = (HttpServletRequest)this.m_msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                int listeningPort = req.getServerPort();
                String listeningHost = InetAddress.getLocalHost().getHostName();
                buf.append("\nContextPath=").append(req.getContextPath()).append("\nServletPath=").append(req.getServletPath()).append("\nPathInfo=").append(req.getPathInfo());
                if (WSRequestForward.logger.isFinest()) {
                    WSRequestForward.logger.finest(m_className, m_method, buf.toString());
                }
                inMessageBuf.append(req.getMethod()).append(" ").append(req.getServletPath()).append(req.getPathInfo()).append(" ").append(req.getProtocol()).append(WSRequestForward.EOL);
                MimeHeaders mimeHeaders = this.m_reqMessage.getMimeHeaders();
                if (mimeHeaders != null && (it = mimeHeaders.getAllHeaders()) != null) {
                    Object obj = null;
                    MimeHeader mimeHeader = null;
                    String headerName = null;
                    while (it.hasNext()) {
                        obj = it.next();
                        if (obj == null || !(obj instanceof MimeHeader)) continue;
                        mimeHeader = obj;
                        headerName = mimeHeader.getName();
                        inMessageBuf.append(headerName).append(": ");
                        if (headerName.compareToIgnoreCase("Host") == 0) {
                            inMessageBuf.append("localhost").append(":").append(listeningPort).append(WSRequestForward.EOL);
                            continue;
                        }
                        if (headerName.compareToIgnoreCase("Content-Length") == 0) {
                            inMessageBuf.append(new String() + soapPart.length()).append(WSRequestForward.EOL);
                            continue;
                        }
                        inMessageBuf.append(mimeHeader.getValue()).append(WSRequestForward.EOL);
                    }
                    inMessageBuf.append(WSRequestForward.EOL);
                }
                inMessageBuf.append(this.m_reqMessage.getSOAPPartAsString()).append(WSRequestForward.EOL);
                String inMessage = inMessageBuf.toString();
                if (WSRequestForward.logger.isFinest()) {
                    WSRequestForward.logger.finest(m_className, m_method, "Request Message to be forwarded = " + inMessage);
                }
                this.m_inputStream = new StringBufferInputStream(inMessage);
                this.m_outputStream = new ByteArrayOutputStream();
            }
            catch (Exception ex) {
            }
            finally {
                WSRequestForward.logger.exiting(m_className, m_method);
            }
        }
    }

    Request(File inFile, OutputStream out, int port, String host) {
        this.m_targetPort = port;
        if (host != null) {
            this.m_targetHost = host;
        }
        try {
            this.sync = inFile;
            this.m_inFile = inFile;
            this.m_inputStream = new FileInputStream(inFile);
            this.m_outputStream = out;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    Request(InputStream in, OutputStream out, int port, String host) {
        this.m_targetPort = port;
        if (host != null) {
            this.m_targetHost = host;
        }
        this.sync = new Object();
        this.m_inputStream = in;
        this.m_outputStream = out;
    }

    synchronized InputStream getInputStream() {
        return this.m_inputStream;
    }

    synchronized OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    synchronized int getTargetPort() {
        return this.m_targetPort;
    }

    synchronized String getTargetHost() {
        return this.m_targetHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doneProcessing(String response) {
        String m_method = "doneProcessing";
        Object object = this.sync;
        synchronized (object) {
            WSRequestForward.logger.entering(m_className, m_method);
            try {
                if (this.m_inFile != null && this.m_inputStream != null) {
                    this.m_inputStream.close();
                    this.m_inputStream = null;
                    this.m_inFile = null;
                }
                if (this.m_msgContext != null) {
                    if (this.m_outputStream != null && this.m_outputStream instanceof ByteArrayOutputStream) {
                        this.m_outputStream.close();
                        this.m_outputStream = null;
                        int index = -1;
                        index = response.toLowerCase().indexOf("<?xml");
                        Message respMessage = null;
                        String respMsg = null;
                        if (index != -1) {
                            respMsg = response.substring(index);
                            respMessage = new Message((Object)respMsg);
                        }
                        if (WSRequestForward.logger.isFinest()) {
                            WSRequestForward.logger.finest(m_className, m_method, "Response message = " + respMsg);
                        }
                        this.m_msgContext.setResponseMessage(respMessage);
                        this.m_msgContext.setPastPivot(true);
                    }
                    if (WSRequestForward.logger.isFinest()) {
                        WSRequestForward.logger.finest(m_className, m_method, "Notify message context");
                    }
                    this.m_msgContext.setProperty("MC.P8BPM.RM.FORWARDED", (Object)Boolean.TRUE);
                    this.m_msgContext.notify();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        WSRequestForward.logger.exiting(m_className, m_method);
    }
}

